//=============================================================================
// Vial.
//=============================================================================
class EndTrigger_Potion extends HealthVial;

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

event float BotDesireability(Pawn Bot)
{

return ( FMin(0.0 , 0.0) ); 

}

auto state Pickup
{	
	function Touch( actor Other )
	{
		
		local Pawn P;
		local PlayerPawn A;
			
		if ( ValidTouch(Other) ) 
		{	
			P = Pawn(Other);
			if (P.IsA('PlayerPawn'))
				{
				PlayPickupMessage(P);
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
				//EndGame("fraglimit");
				Level.Game.EndGame("fraglimit");
				foreach AllActors(class'PlayerPawn', A)
					{
					A.GotoState('GameEnded');
					}
				}
		}
	}
}

defaultproperties
{
     HealingAmount=0
     bSuperHeal=False
     PickupMessage="Congratulations! You found the potion!"
     ItemName="Potion"
     RespawnTime=9999.00000
     PickupViewMesh=LodMesh'Botpack.Vial'
     PickupSound=Sound'Botpack.CTF.CaptureSound2'
     Mesh=LodMesh'Botpack.Vial'
     ScaleGlow=2.000000
     CollisionRadius=14.000000
     CollisionHeight=16.000000
     MultiSkins(1)=Texture'UnrealShare.Effect3.fireeffect3'
     MultiSkins(2)=Texture'UnrealShare.Effects.PalGreen'
}
